/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class BlacksmithModifier
extends Modifier
implements ConditionalStatModifierHook {
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT);
    }

    public void addToolStats(ToolRebuildContext context, int level, ModifierStatsBuilder builder) {
        ToolStats.DURABILITY.multiply(builder, 1.0 + 0.08 * (double)level);
    }

    public float getEntityDamage(@Nonnull IToolStackView tool, int level, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity living = context.getAttacker();
        if (living.m_20186_() <= 64.0 && living.m_20186_() >= 0.0) {
            return (float)((double)damage * (1.0 + (64.0 - living.m_20186_()) * 0.0016));
        }
        return damage;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (living.m_20186_() <= 64.0 && living.m_20186_() >= 0.0) {
            if (stat == ToolStats.VELOCITY) {
                return (float)((double)baseValue * (1.0 + (64.0 - living.m_20186_()) * 0.016));
            }
            if (stat == ToolStats.ATTACK_SPEED) {
                return (float)((double)baseValue * (1.0 - (64.0 - living.m_20186_()) * 0.016));
            }
        }
        return baseValue;
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (player != null && harvest || tool.hasTag(TinkerTags.Items.RANGED)) {
            double y = player.m_20186_();
            if (key == TooltipKey.SHIFT && y >= 0.0 && y <= 64.0) {
                if (harvest) {
                    this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.blacksmith.attack_damage"), (64.0 - y) * 0.0016, tooltip);
                    this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.blacksmith.attack_speed"), 1.0 - (64.0 - y) * 0.0016, tooltip);
                } else {
                    this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.blacksmith.velocity"), (64.0 - y) * 0.016, tooltip);
                }
            }
        }
    }
}

